/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterListener;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterManager;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ReaderWriterManager
implements IReaderWriterManager {
    private static final String NBT_CHANNELS = "ReaderWriterChannels";
    private static final String NBT_NAME = "Name";
    private final INetwork network;
    private final Map<String, IReaderWriterChannel> channels = new HashMap<String, IReaderWriterChannel>();
    private final Set<IReaderWriterListener> listeners = new HashSet<IReaderWriterListener>();

    public ReaderWriterManager(INetwork network) {
        this.network = network;
    }

    @Override
    public void update() {
        for (IReaderWriterChannel channel : this.channels.values()) {
            for (IReaderWriterHandler handler : channel.getHandlers()) {
                handler.update(channel);
            }
        }
    }

    @Override
    @Nullable
    public IReaderWriterChannel getChannel(String name) {
        return this.channels.get(name);
    }

    @Override
    public void addChannel(String name) {
        this.channels.put(name, API.instance().createReaderWriterChannel(name, this.network));
        this.listeners.forEach(IReaderWriterListener::onChanged);
    }

    @Override
    public void removeChannel(String name) {
        IReaderWriterChannel channel = this.getChannel(name);
        if (channel != null) {
            channel.invalidate();
            this.channels.remove(name);
            this.listeners.forEach(IReaderWriterListener::onChanged);
        }
    }

    @Override
    public Collection<String> getChannels() {
        return this.channels.keySet();
    }

    @Override
    public void addListener(IReaderWriterListener listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IReaderWriterListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void writeToNbt(NBTTagCompound tag) {
        NBTTagList readerWriterChannelsList = new NBTTagList();
        for (Map.Entry<String, IReaderWriterChannel> entry : this.channels.entrySet()) {
            NBTTagCompound channelTag = entry.getValue().writeToNbt(new NBTTagCompound());
            channelTag.func_74778_a(NBT_NAME, entry.getKey());
            readerWriterChannelsList.func_74742_a((NBTBase)channelTag);
        }
        tag.func_74782_a(NBT_CHANNELS, (NBTBase)readerWriterChannelsList);
    }

    @Override
    public void readFromNbt(NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_CHANNELS)) {
            NBTTagList readerWriterChannelsList = tag.func_150295_c(NBT_CHANNELS, 10);
            for (int i = 0; i < readerWriterChannelsList.func_74745_c(); ++i) {
                NBTTagCompound channelTag = readerWriterChannelsList.func_150305_b(i);
                String name = channelTag.func_74779_i(NBT_NAME);
                IReaderWriterChannel channel = API.instance().createReaderWriterChannel(name, this.network);
                channel.readFromNbt(channelTag);
                this.channels.put(name, channel);
            }
        }
    }
}

